/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.psg;

import frc.emul.api.ILogger;
import frc.emul.api.persistence.IPersistenceReader;
import frc.emul.api.persistence.IPersistenceWriter;
import frc.emul.api.persistence.IPersistentSection;
import frc.emul.api.persistence.PersistenceException;
import frc.emul.psg.IAudioSettings;
import frc.emul.psg.IPsgCore;
import frc.emul.psg.dev.ISamplesProcessor;
import frc.emul.psg.dev.PsgRecording;
import frc.emul.util.Utils;
import frc.emul.vectrex.PersistentSection;
import frc.emul.via6522.I6522InternalLines;
import java.io.PrintStream;

public class AY38912
implements IPsgCore {
    private final ILogger logger;
    public static final int MAX_OUTPUT = Short.MAX_VALUE;
    public static final int STEP = 4096;
    public static final int REG_AFINE = 0;
    public static final int REG_ACOARSE = 1;
    public static final int REG_BFINE = 2;
    public static final int REG_BCOARSE = 3;
    public static final int REG_CFINE = 4;
    public static final int REG_CCOARSE = 5;
    public static final int REG_NOISEPER = 6;
    public static final int REG_ENABLE = 7;
    public static final int REG_AVOL = 8;
    public static final int REG_BVOL = 9;
    public static final int REG_CVOL = 10;
    public static final int REG_EFINE = 11;
    public static final int REG_ECOARSE = 12;
    public static final int REG_ESHAPE = 13;
    public static final int REG_PORTA = 14;
    public static final int REG_PORTB = 15;
    public static final int ENABLE_BIT_TONE_A = 1;
    public static final int ENABLE_BIT_TONE_B = 2;
    public static final int ENABLE_BIT_TONE_C = 3;
    public static final int ENABLE_BIT_NOISE_A = 4;
    public static final int ENABLE_BIT_NOISE_B = 5;
    public static final int ENABLE_BIT_NOISE_C = 6;
    public static final int ENABLE_BIT_IOA = 7;
    public static final int ENABLE_BIT_IOB = 8;
    public static final int ENABLE_TONE_A = 1;
    public static final int ENABLE_TONE_B = 2;
    public static final int ENABLE_TONE_C = 4;
    public static final int ENABLE_NOISE_A = 8;
    public static final int ENABLE_NOISE_B = 16;
    public static final int ENABLE_NOISE_C = 32;
    public static final int ENABLE_IOA = 64;
    public static final int ENABLE_IOB = 128;
    public static final int ENABLE_NOISE_ABC = 56;
    private transient ISamplesProcessor samplesProcessor;
    private transient boolean muteChannelA;
    private transient boolean muteChannelB;
    private transient boolean muteChannelC;
    private transient int ticksPerSample;
    private transient int[] volume = new int[32];
    private int[] regs = new int[16];
    private int RNG;
    private int countEnv;
    private int envelopeA;
    private int envelopeB;
    private int envelopeC;
    private int periodA;
    private int periodB;
    private int periodC;
    private int periodE;
    private int periodN;
    private int countA;
    private int countB;
    private int countC;
    private int countE;
    private int countN;
    private int volA;
    private int volB;
    private int volC;
    private int volE;
    private boolean outputA;
    private boolean outputB;
    private boolean outputC;
    private int outputN;
    private boolean attack;
    private boolean hold;
    private boolean holding;
    private boolean alternate;
    private boolean mute;

    public AY38912(ILogger iLogger, I6522InternalLines i6522InternalLines) {
        this.logger = iLogger;
    }

    public ILogger getLogger() {
        return this.logger;
    }

    public ISamplesProcessor getSamplesProcessor() {
        return this.samplesProcessor;
    }

    public synchronized void setSamplesProcessor(ISamplesProcessor iSamplesProcessor) {
        this.samplesProcessor = iSamplesProcessor;
        if (iSamplesProcessor != null) {
            iSamplesProcessor.setMute(this.isMute());
        }
    }

    public final boolean isMute() {
        return this.mute;
    }

    public final synchronized void setMute(boolean bl) {
        if (bl != this.mute) {
            if (this.samplesProcessor != null) {
                this.samplesProcessor.setMute(bl);
            }
            this.mute = bl;
            this.resetFeeder();
        }
    }

    public void initialise(IAudioSettings iAudioSettings) {
        this.updateSettings(iAudioSettings);
    }

    public void updateSettings(IAudioSettings iAudioSettings) {
        AY38912.initMixerTable(this.volume, iAudioSettings.getVolumeLevel(), Short.MAX_VALUE);
        this.muteChannelA = iAudioSettings.isChannelAMuted();
        this.muteChannelB = iAudioSettings.isChannelBMuted();
        this.muteChannelC = iAudioSettings.isChannelCMuted();
        int n = this.ticksPerSample;
        int n2 = iAudioSettings.getSampleRate();
        long l = iAudioSettings.getClockRate();
        this.ticksPerSample = (int)((double)(4096 * n2) / ((double)l / 8.0));
        if (n == 0 || n != this.ticksPerSample) {
            this.reset();
        }
    }

    public void reset() {
        this.resetFeeder();
        this.RNG = 1;
        int n = 0;
        while (n++ < 3) {
            int n2 = 0;
            while (n2 < 14) {
                this.writeImpl(n2, 0);
                ++n2;
            }
        }
    }

    private void resetFeeder() {
        this.outputN = 255;
        this.outputC = false;
        this.outputB = false;
        this.outputA = false;
        this.countE = 0;
        this.countC = 0;
        this.countB = 0;
        this.countA = 0;
    }

    public void writeRegister(int n, int n2) {
        this.writeImpl(n, n2);
    }

    public int readRegister(int n) {
        return this.regs[n];
    }

    public final synchronized void dump(PrintStream printStream) {
        String[] stringArray = new String[]{"REG_AFINE", "REG_ACOARSE", "REG_BFINE", "REG_BCOARSE", "REG_CFINE", "REG_CCOARSE", "REG_NOISEPER", "REG_ENABLE", "REG_AVOL", "REG_BVOL", "REG_CVOL", "REG_EFINE", "REG_ECOARSE", "REG_ESHAPE", "REG_PORTA", "REG_PORTB"};
        int n = 0;
        while (n < stringArray.length) {
            printStream.println("Reg #" + n + "\t= $" + Utils.HEX(2, this.regs[n]) + " (%" + Utils.bin(8, this.regs[n]) + ")\t// " + stringArray[n]);
            ++n;
        }
    }

    public synchronized void feed(int[] nArray, int n, int n2) {
        if (this.mute) {
            return;
        }
        ISamplesProcessor iSamplesProcessor = this.samplesProcessor;
        if (iSamplesProcessor != null) {
            iSamplesProcessor.startFeeding(n2);
        }
        int[] nArray2 = this.volume;
        int n3 = n2;
        int n4 = n3 * 4096;
        int n5 = this.regs[7];
        int n6 = 12288;
        int n7 = 1;
        int n8 = 1;
        int n9 = 1;
        if (this.muteChannelA) {
            n7 = 0;
            n6 -= 4096;
        }
        if (this.muteChannelB) {
            n8 = 0;
            n6 -= 4096;
        }
        if (this.muteChannelC) {
            n9 = 0;
            n6 -= 4096;
        }
        if (n6 == 0) {
            n6 = 1;
        }
        if ((this.regs[0] | this.regs[1]) == 0 && (this.regs[8] & 0x10) == 0 && (n5 & 9) == 8) {
            n7 = 0;
        }
        if ((this.regs[2] | this.regs[3]) == 0 && (this.regs[9] & 0x10) == 0 && (n5 & 0x12) == 16) {
            n8 = 0;
        }
        if ((this.regs[4] | this.regs[5]) == 0 && (this.regs[10] & 0x10) == 0 && (n5 & 0x24) == 32) {
            n9 = 0;
        }
        int n10 = this.volA * n7;
        int n11 = this.volB * n8;
        int n12 = this.volC * n9;
        if ((n5 & 1) != 0) {
            if (this.countA <= n4) {
                this.countA += n4;
            }
            this.outputA = true;
        } else if (this.regs[8] == 0 && this.countA <= n4) {
            this.countA += n4;
        }
        if ((n5 & 2) != 0) {
            if (this.countB <= n4) {
                this.countB += n4;
            }
            this.outputB = true;
        } else if (this.regs[9] == 0 && this.countB <= n4) {
            this.countB += n4;
        }
        if ((n5 & 4) != 0) {
            if (this.countC <= n4) {
                this.countC += n4;
            }
            this.outputC = true;
        } else if (this.regs[10] == 0 && this.countC <= n4) {
            this.countC += n4;
        }
        if ((n5 & 0x38) == 56 && this.countN <= n4) {
            this.countN += n4;
        }
        int n13 = this.outputN | n5;
        while (n3 > 0) {
            int n14;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 4096;
            do {
                int n19 = n14 = this.countN < n18 ? this.countN : n18;
                if ((n13 & 8) != 0) {
                    if (this.outputA) {
                        n15 += this.countA;
                    }
                    this.countA -= n14;
                    while (this.countA <= 0) {
                        this.countA += this.periodA;
                        if (this.countA > 0) {
                            this.outputA = !this.outputA;
                            if (!this.outputA) break;
                            n15 += this.periodA;
                            break;
                        }
                        this.countA += this.periodA;
                        n15 += this.periodA;
                    }
                    if (this.outputA) {
                        n15 -= this.countA;
                    }
                } else {
                    this.countA -= n14;
                    while (this.countA <= 0) {
                        this.countA += this.periodA;
                        if (this.countA > 0) {
                            this.outputA = !this.outputA;
                            break;
                        }
                        this.countA += this.periodA;
                    }
                }
                if ((n13 & 0x10) != 0) {
                    if (this.outputB) {
                        n16 += this.countB;
                    }
                    this.countB -= n14;
                    while (this.countB <= 0) {
                        this.countB += this.periodB;
                        if (this.countB > 0) {
                            this.outputB = !this.outputB;
                            if (!this.outputB) break;
                            n16 += this.periodB;
                            break;
                        }
                        this.countB += this.periodB;
                        n16 += this.periodB;
                    }
                    if (this.outputB) {
                        n16 -= this.countB;
                    }
                } else {
                    this.countB -= n14;
                    while (this.countB <= 0) {
                        this.countB += this.periodB;
                        if (this.countB > 0) {
                            this.outputB = !this.outputB;
                            break;
                        }
                        this.countB += this.periodB;
                    }
                }
                if ((n13 & 0x20) != 0) {
                    if (this.outputC) {
                        n17 += this.countC;
                    }
                    this.countC -= n14;
                    while (this.countC <= 0) {
                        this.countC += this.periodC;
                        if (this.countC > 0) {
                            this.outputC = !this.outputC;
                            if (!this.outputC) break;
                            n17 += this.periodC;
                            break;
                        }
                        this.countC += this.periodC;
                        n17 += this.periodC;
                    }
                    if (this.outputC) {
                        n17 -= this.countC;
                    }
                } else {
                    this.countC -= n14;
                    while (this.countC <= 0) {
                        this.countC += this.periodC;
                        if (this.countC > 0) {
                            this.outputC = !this.outputC;
                            break;
                        }
                        this.countC += this.periodC;
                    }
                }
                this.countN -= n14;
                if (this.countN > 0) continue;
                if ((this.RNG + 1 & 2) != 0) {
                    this.outputN ^= 0xFFFFFFFF;
                    n13 = this.outputN | n5;
                }
                if ((this.RNG & 1) != 0) {
                    this.RNG ^= 0x24000;
                }
                this.RNG >>= 1;
                this.countN += this.periodN;
            } while ((n18 -= n14) > 0);
            if (!this.holding) {
                this.countE -= 4096;
                if (this.countE <= 0) {
                    do {
                        --this.countEnv;
                        this.countE += this.periodE;
                    } while (this.countE <= 0);
                    if (this.countEnv < 0) {
                        if (this.hold) {
                            this.attack ^= this.alternate;
                            this.holding = true;
                            this.countEnv = 0;
                        } else {
                            this.attack ^= this.alternate && (this.countEnv & 0x20) != 0;
                            this.countEnv &= 0x1F;
                        }
                    }
                    this.volE = nArray2[this.attack ? this.countEnv ^ 0x1F : this.countEnv];
                    if (this.envelopeA != 0) {
                        this.volA = this.volE;
                        n10 = this.volE * n7;
                    }
                    if (this.envelopeB != 0) {
                        this.volB = this.volE;
                        n11 = this.volE * n8;
                    }
                    if (this.envelopeC != 0) {
                        this.volC = this.volE;
                        n12 = this.volE * n9;
                    }
                }
            }
            n14 = (n15 * n10 + n16 * n11 + n17 * n12) / n6;
            if (iSamplesProcessor != null) {
                iSamplesProcessor.feedSample(n14, n15 * n10 / 4096, n16 * n11 / 4096, n17 * n12 / 4096);
            }
            nArray[n++] = n14;
            --n3;
        }
        if (iSamplesProcessor != null) {
            iSamplesProcessor.endFeeding(n2);
        }
    }

    private static void initMixerTable(int[] nArray, float f, int n) {
        double d = Math.min(1.0f, Math.max(0.0f, f));
        double d2 = n;
        double d3 = Math.pow(10.0, 0.075);
        nArray[31] = (int)(d2 * d);
        int n2 = 31;
        while (--n2 > 0) {
            nArray[n2] = (int)((d2 /= d3) * d + 0.5);
        }
    }

    private synchronized void writeImpl(int n, int n2) {
        PsgRecording.INSTANCE.addRecord(n, n2);
        switch (n) {
            case 1: {
                n2 &= 0xF;
            }
            case 0: {
                this.regs[n] = n2 & 0xFF;
                int n3 = this.periodA;
                this.periodA = (this.regs[0] + 256 * this.regs[1]) * this.ticksPerSample;
                if (this.periodA == 0) {
                    this.periodA = this.ticksPerSample;
                }
                this.countA += this.periodA - n3;
                if (this.countA > 0) break;
                this.countA = 1;
                break;
            }
            case 3: {
                n2 &= 0xF;
            }
            case 2: {
                this.regs[n] = n2 & 0xFF;
                int n4 = this.periodB;
                this.periodB = (this.regs[2] + 256 * this.regs[3]) * this.ticksPerSample;
                if (this.periodB == 0) {
                    this.periodB = this.ticksPerSample;
                }
                this.countB += this.periodB - n4;
                if (this.countB > 0) break;
                this.countB = 1;
                break;
            }
            case 5: {
                n2 &= 0xF;
            }
            case 4: {
                this.regs[n] = n2 & 0xFF;
                int n5 = this.periodC;
                this.periodC = (this.regs[4] + 256 * this.regs[5]) * this.ticksPerSample;
                if (this.periodC == 0) {
                    this.periodC = this.ticksPerSample;
                }
                this.countC += this.periodC - n5;
                if (this.countC > 0) break;
                this.countC = 1;
                break;
            }
            case 6: {
                this.regs[6] = n2 &= 0x1F;
                int n6 = this.periodN;
                this.periodN = n2 * this.ticksPerSample;
                if (this.periodN == 0) {
                    this.periodN = this.ticksPerSample;
                }
                this.countN += this.periodN - n6;
                if (this.countN > 0) break;
                this.countN = 1;
                break;
            }
            case 8: {
                this.regs[8] = n2 &= 0x1F;
                this.envelopeA = n2 & 0x10;
                this.volA = this.envelopeA != 0 ? this.volE : this.volume[n2 != 0 ? n2 * 2 + 1 : 0];
                break;
            }
            case 9: {
                this.regs[9] = n2 &= 0x1F;
                this.envelopeB = n2 & 0x10;
                this.volB = this.envelopeB != 0 ? this.volE : this.volume[n2 != 0 ? n2 * 2 + 1 : 0];
                break;
            }
            case 10: {
                this.regs[10] = n2 &= 0x1F;
                this.envelopeC = n2 & 0x10;
                this.volC = this.envelopeC != 0 ? this.volE : this.volume[n2 != 0 ? n2 * 2 + 1 : 0];
                break;
            }
            case 11: 
            case 12: {
                this.regs[n] = n2 & 0xFF;
                int n7 = this.periodE;
                this.periodE = (this.regs[11] + 256 * this.regs[12]) * this.ticksPerSample;
                if (this.periodE == 0) {
                    this.periodE = this.ticksPerSample / 2;
                }
                this.countE += this.periodE - n7;
                if (this.countE > 0) break;
                this.countE = 1;
                break;
            }
            case 13: {
                this.regs[13] = n2 &= 0xF;
                this.countEnv = 31;
                this.countE = this.periodE;
                this.holding = false;
                if ((n2 & 4) != 0) {
                    this.attack = true;
                    this.volE = this.volume[0];
                } else {
                    this.attack = false;
                    this.volE = this.volume[31];
                }
                if (this.envelopeA != 0) {
                    this.volA = this.volE;
                }
                if (this.envelopeB != 0) {
                    this.volB = this.volE;
                }
                if (this.envelopeC != 0) {
                    this.volC = this.volE;
                }
                if ((n2 & 8) == 0) {
                    this.alternate = this.attack;
                    this.hold = true;
                    break;
                }
                this.alternate = (n2 & 2) != 0;
                this.hold = (n2 & 1) != 0;
                break;
            }
            case 7: 
            case 14: 
            case 15: {
                this.regs[n] = n2;
            }
        }
    }

    public IPersistentSection getSection() {
        return PersistentSection.AUDIO_PSG;
    }

    public void store(IPersistenceWriter iPersistenceWriter) throws PersistenceException {
        iPersistenceWriter.openSection(PersistentSection.AUDIO_PSG_REGS);
        int[] nArray = this.regs;
        int n = this.regs.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray[n2];
            iPersistenceWriter.write8(n3);
            ++n2;
        }
        iPersistenceWriter.closeSection();
        iPersistenceWriter.write(this.RNG);
        iPersistenceWriter.write8(this.countEnv);
        iPersistenceWriter.write8(this.envelopeA);
        iPersistenceWriter.write8(this.envelopeB);
        iPersistenceWriter.write8(this.envelopeC);
        iPersistenceWriter.write(this.periodA);
        iPersistenceWriter.write(this.periodB);
        iPersistenceWriter.write(this.periodC);
        iPersistenceWriter.write(this.periodE);
        iPersistenceWriter.write(this.periodN);
        iPersistenceWriter.write(this.countA);
        iPersistenceWriter.write(this.countB);
        iPersistenceWriter.write(this.countC);
        iPersistenceWriter.write(this.countE);
        iPersistenceWriter.write(this.countN);
        iPersistenceWriter.write(this.volA);
        iPersistenceWriter.write(this.volB);
        iPersistenceWriter.write(this.volC);
        iPersistenceWriter.write(this.volE);
        iPersistenceWriter.write(this.outputA);
        iPersistenceWriter.write(this.outputB);
        iPersistenceWriter.write(this.outputC);
        iPersistenceWriter.write8(this.outputN);
        iPersistenceWriter.write(this.attack);
        iPersistenceWriter.write(this.hold);
        iPersistenceWriter.write(this.holding);
        iPersistenceWriter.write(this.alternate);
    }

    public void load(IPersistenceReader iPersistenceReader) throws PersistenceException {
        iPersistenceReader.openSection(PersistentSection.AUDIO_PSG_REGS);
        int n = 0;
        while (n < this.regs.length) {
            this.regs[n] = iPersistenceReader.readU8();
            ++n;
        }
        iPersistenceReader.closeSection();
        this.RNG = iPersistenceReader.readInt();
        this.countEnv = iPersistenceReader.readS8();
        this.envelopeA = iPersistenceReader.readU8();
        this.envelopeB = iPersistenceReader.readU8();
        this.envelopeC = iPersistenceReader.readU8();
        this.periodA = iPersistenceReader.readInt();
        this.periodB = iPersistenceReader.readInt();
        this.periodC = iPersistenceReader.readInt();
        this.periodE = iPersistenceReader.readInt();
        this.periodN = iPersistenceReader.readInt();
        this.countA = iPersistenceReader.readInt();
        this.countB = iPersistenceReader.readInt();
        this.countC = iPersistenceReader.readInt();
        this.countE = iPersistenceReader.readInt();
        this.countN = iPersistenceReader.readInt();
        this.volA = iPersistenceReader.readInt();
        this.volB = iPersistenceReader.readInt();
        this.volC = iPersistenceReader.readInt();
        this.volE = iPersistenceReader.readInt();
        this.outputA = iPersistenceReader.readBool();
        this.outputB = iPersistenceReader.readBool();
        this.outputC = iPersistenceReader.readBool();
        this.outputN = iPersistenceReader.readU8();
        this.attack = iPersistenceReader.readBool();
        this.hold = iPersistenceReader.readBool();
        this.holding = iPersistenceReader.readBool();
        this.alternate = iPersistenceReader.readBool();
    }
}

